set autoscale 
set xtic auto 
set ytic auto 
set style line  1 lt 1 lw 3 lc rgb "#000000"
set style line  2 lt 1 lw 3 lc rgb "#FF0000"
set style line  3 lt 1 lw 3 lc rgb "#FF0000"
 
set xlabel "E (eV)" font "Times,12"
set ylabel "Intensity (arb. units)" font "Times,12"
 
set out 'XASSpec.ps'
set size 1.0, 0.7
set terminal postscript portrait enhanced color  "Times" 12
 
set multiplot layout 3, 3
 
plot "XASSpec.dat"  u 1:(-$3 ) title 'z-polarized Sz=-1' with lines ls  1
plot "XASSpec.dat"  u 1:(-$5 ) title 'z-polarized Sz= 0' with lines ls  1
plot "XASSpec.dat"  u 1:(-$7 ) title 'z-polarized Sz= 1' with lines ls  1
plot "XASSpec.dat"  u 1:(-$9 ) title 'r-polarized Sz=-1' with lines ls  1
plot "XASSpec.dat"  u 1:(-$11) title 'r-polarized Sz= 0' with lines ls  1
plot "XASSpec.dat"  u 1:(-$13) title 'r-polarized Sz= 1' with lines ls  1
plot "XASSpec.dat"  u 1:(-$15) title 'l-polarized Sz=-1' with lines ls  1
plot "XASSpec.dat"  u 1:(-$17) title 'l-polarized Sz= 0' with lines ls  1
plot "XASSpec.dat"  u 1:(-$19) title 'l-polarized Sz= 1' with lines ls  1
 
unset multiplot
 
energyshift=857.6
intensityscale=49
 
set xrange [847:877]

plot "XASSpec.dat" using ($1+energyshift):((-$3-$9-$15) * intensityscale) title 'isotropic theory' with lines ls 2,\
     "../../NiO Experiment/XAS_L23_PRB_57_11623_1998" using 1:2 title 'isotropic experiment' with lines ls 1
 
 
set size 1.0, 0.6
intensityscale=48
set out 'XASIsoSpec.ps'
set xrange [847:877]
 
plot "../../NiO Experiment/XAS_L23_PRB_57_11623_1998" using 1:2 title 'isotropic experiment' with filledcurves y1=0,\
     "XASIsoSpec.dat" using ($1+energyshift):((-$3) * intensityscale) title 'isotropic theory' with lines ls 3
 
